
(

s = Server.local;

// define a simple tone
SynthDef("sine", { arg freq = 440, amp = 0.2, out = 0;
	var osc;
	osc = SinOsc.ar(freq, 0, amp);
	Out.ar(out, osc);
}).writeDefFile;
s.sendSynthDef("sine");

// define a noise pulse
SynthDef("tish", { arg rate = 2, amp = 0.5;
	var osc, trg;
	trg = Decay2.ar(Impulse.ar(rate,0, 0.3), 0.01, 0.3, amp);
	osc = {WhiteNoise.ar(trg)}.dup;
	Out.ar(0, osc);
}).writeDefFile;
s.sendSynthDef("tish");

// define a sine pulse
SynthDef("pulse", { arg freq = 440, rate = 2, amp = 0.5;
	var osc, trg;
	trg = Decay2.ar(Impulse.ar(rate,0, 0.3), 0.01, 0.3, amp);
	osc = {SinOsc.ar(freq,0, trg)}.dup;
	Out.ar(0, osc);
}).writeDefFile;
s.sendSynthDef("pulse");

// define an echo effect
SynthDef("echo", { arg delay = 0.2, decay = 4;
	var in;
	in = In.ar(0,2);
	ReplaceOut.ar(0, CombN.ar(in, 2.0, delay, decay, 1, in));
}).writeDefFile;
s.sendSynthDef("echo");

)



